#!/bin/bash
#SBATCH --mem=16g
#SBATCH --time=16:00:00

module load jdk/8.u181


REF=../HUMAN_REFS/HG38/REF_HLA/GRCh38_full_analysis_set_plus_decoy_hla.fa
DBSITES=../HUMAN_REFS/HG38/common_dbsnp_151.hg38.vcf


mkdir -p /new_parent_directory
cd /new_parent_directory
#########################
# GATK variants calling
#########################

java -Xms12G -Xmx16G -jar /local/software/GATK/gatk-4.1.2.0/gatk-package-4.1.2.0-local.jar \
               GenomicsDBImport \
                      --genomicsdb-workspace-path $2 \
                             --batch-size 30 \
                                    -L $1 \
                                    --merge-input-intervals true \
                                        --sample-name-map ../PIBD.sample_map \
                                                  --tmp-dir ../tmp \
                                                         --reader-threads 10

java -Xms12g -Xmx16G -jar /local/software/GATK/gatk-4.1.2.0/gatk-package-4.1.2.0-local.jar \
        GenotypeGVCFs \
            -R ${REF} \
            -L $1 --only-output-calls-starting-in-intervals \
            --merge-input-intervals true \
                -O ${2}.vcf.gz \
                    -D ${DBSITES} \
                        -new-qual \
                                -V gendb:///new_parent_directory/$2
